 <?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package Vision Lite
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width">
<link rel="profile" href="https://gmpg.org/xfn/11">
<?php if(is_singular() && pings_open()) { ?>
<link rel="pingback" href="<?php echo esc_url( get_bloginfo( 'pingback_url' )); ?>">
<?php } ?>
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php
	//wp_body_open hook from WordPress 5.2
	if ( function_exists( 'wp_body_open' ) ) {
	    wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
?>
<a class="skip-link screen-reader-text" href="#sitemain">
	<?php _e( 'Skip to content', 'vision-lite' ); ?>
</a>

<div class="header-top">
  <div class="head-top-inner">
     <div class="toggle">
            <a class="toggleMenu" href="#">
                <?php esc_attr_e('Menu','vision-lite'); ?>                
            </a>
    	</div><!-- toggle -->    
    <div class="sitenav">                   
   	 	<?php wp_nav_menu( array('theme_location' => 'primary') ); ?> 
    </div><!--.sitenav -->
     
     <div class="clear"></div>
  </div><!-- head-top-inner -->
 </div><!--end header-top--> 
<div class="clear"></div>


<div id="header">
	<div class="header-inner">
      <div class="logo">
           <?php vision_lite_the_custom_logo(); ?>
			    <h1><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php esc_html(bloginfo( 'name' )); ?></a></h1>
					<?php $description = get_bloginfo( 'description', 'display' );
						if ( $description || is_customize_preview() ) : ?>
						<p><?php echo esc_html($description); ?></p>
					<?php endif; ?>
      </div><!-- logo -->                    
    <div class="header_right"> 
        <?php if(get_theme_mod('donate_link',true) != '') { ?>
        	<a href="<?php echo esc_url( get_theme_mod('donate_link') ); ?>" class="morebutton"><?php esc_html_e('Donate Now','vision-lite'); ?></a>
        <?php } ?>
        <div class="clear"></div>
    </div><!--header_right-->    
 <div class="clear"></div>
</div><!-- .header-inner-->
</div><!-- .header -->